package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B44T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B44T00DAO {
	
	static private P06B44T00DAO instance = null;

	public static P06B44T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B44T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B44T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene la lista de entidades de Crdito del Modelo 0 de la DEC, asociadas al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de objetos entidades de Crdito DEC Modelo 0
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B44T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B44T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B44T00Datatype();

			    obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B44_EJERCICIO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B44_NUMEXP));
			    obj.setClave(lrst.getString(P06BTablas.P06B_P06B44_CLAVE));
			    obj.setTipoPer(lrst.getString(P06BTablas.P06B_P06B44_TIPOPER)==null?"":lrst.getString(P06BTablas.P06B_P06B44_TIPOPER));
			    obj.setNif(lrst.getString(P06BTablas.P06B_P06B44_NIF)==null?"":lrst.getString(P06BTablas.P06B_P06B44_NIF));
			    obj.setDenom(lrst.getString(P06BTablas.P06B_P06B44_DENOM)==null?"":lrst.getString(P06BTablas.P06B_P06B44_DENOM));
			    obj.setFhContrato(lrst.getString(P06BTablas.P06B_P06B44_FH_CONTRATO)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B44_FH_CONTRATO),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
			    
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B44T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	

	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B44_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B44_NUMEXP + ", "
		+ P06BTablas.P06B_P06B44_CLAVE + ", "
		+ P06BTablas.P06B_P06B44_TIPOPER + ", "
		+ P06BTablas.P06B_P06B44_NIF + ", "
		+ P06BTablas.P06B_P06B44_DENOM + ", "
		+ P06BTablas.P06B_P06B44_FH_CONTRATO +
		
		" FROM " + P06BTablas.P06B_P06B44T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B44_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B44_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B44_CLAVE ;

}
